@echo off
chcp 437 > NUL
pushd "%~dp0"

setlocal enableextensions
set asussci_logpath=%ProgramData%\ASUS\ASUS System Control Interface\log
echo Install ASUS System Control Interface  V3 driver
echo Please wait......
echo.
echo Create folder: "%asussci_logpath%"
mkdir "%asussci_logpath%"
echo logpath="%asussci_logpath%"
echo.
call :InstallSub > "%asussci_logpath%\setup_asci.log" 2>&1
echo.
echo Exit installation script!
endlocal
exit /b


:InstallSub
call :OutputLogWithTime ASCI V3 Driver installer
echo.
call :OutputLogWithTime Start installation procedure
echo.

:: ==========================================================
:: Change service auto-start configuration
:: ==========================================================
call :ScConfigService ASUSLinkNearExt disabled
call :ScConfigService ASUSLinkNear disabled
call :ScConfigService ASUSLinkRemote disabled
call :ScConfigService ASUSSystemAnalysis disabled
call :ScConfigService ASUSSystemDiagnosis disabled
call :ScConfigService ASUSOptimization disabled
call :ScConfigService ASUSSoftwareManager disabled

:: ==========================================================
:: Stop service before install ASCI driver
:: ==========================================================
call :ScStopService ASUSLinkNearExt
call :ScStopService ASUSLinkNear
call :ScStopService ASUSLinkRemote
call :ScStopService ASUSSystemAnalysis
call :ScStopService ASUSSystemDiagnosis
call :ScStopService ASUSOptimization


:: ==========================================================
:: Try to kill the process that can't stop
:: ==========================================================
call :OutputLogWithTime ASCI V3 [asussci2.inf] Information:
findstr /l "DriverVer" "%~dp0\asussci2.inf"
echo.
call :OutputASUSDeviceInformation
echo.
timeout /t 10 /nobreak
call :OutputLogWithTime Check all services have been stop...
taskkill /F /IM AsusLinkNearExt.exe
taskkill /F /IM AsusLinkNear.exe
taskkill /F /IM AsusLinkRemote.exe
taskkill /F /IM AsusOptimization.exe
taskkill /F /IM AsusSystemAnalysis.exe
taskkill /F /IM AsusSystemDiagnosis.exe
timeout /t 1 /nobreak

:: ==========================================================
:: Intall ASCI V3 driver
:: ==========================================================
echo ----------------------------------------------------------
call :OutputLogWithTime Start to run pnputil tool...
echo.
pnputil -i -a .\asussci2.inf
set pnputilExitCode=%errorlevel%

call :OutputLogWithTime Fill the pnputil tool result to registry...

reg add "HKLM\SOFTWARE\ASUS\ASUS System Control Interface" /v Result /t REG_SZ /d %pnputilExitCode% /f /reg:64
call :OutputLogWithTime pnputil Exit Code=%pnputilExitCode%
echo ----------------------------------------------------------
echo.
:: ==========================================================
:: Update service auto-start configuration
:: ==========================================================
timeout /t 1 /nobreak
echo.
call :OutputLogWithTime Update service configuration
call :ScConfigService ASUSLinkNearExt auto
call :ScConfigService ASUSLinkNear auto
call :ScConfigService ASUSLinkRemote auto
call :ScConfigService ASUSSystemAnalysis auto
call :ScConfigService ASUSSystemDiagnosis auto
call :ScConfigService ASUSOptimization auto
call :ScConfigService ASUSSoftwareManager auto

echo.
:: ==========================================================
:: Make sure that all services have been started
:: ==========================================================
call :OutputLogWithTime Check all service has been started...
call :ScStartService ASUSOptimization
call :ScStartService ASUSSystemDiagnosis
call :ScStartService ASUSSystemAnalysis
call :ScStartService ASUSLinkRemote
call :ScStartService ASUSLinkNear
call :ScStartService ASUSLinkNearExt
call :ScStartService ASUSSoftwareManager

echo.
call :GetUnixTime UNIX_TIME
echo Current UNIX Timestamp=%UNIX_TIME%

call :OutputLogWithTime Backup setup_asci.log
echo logpath="%asussci_logpath%"
mkdir "%asussci_logpath%"
copy "%asussci_logpath%\setup_asci.log" "%asussci_logpath%\setup_asci_%UNIX_TIME%.log"
echo.

call :OutputLogWithTime Backup setupapi.dev.log
copy %windir%\INF\setupapi.dev.log "%asussci_logpath%\setupapi.dev.log"
echo.

call :OutputLogWithTime Update timestatmp in registry...
reg add "HKLM\SOFTWARE\ASUS\ASUS System Control Interface" /v LastSelfUpdateFinishedTime /t REG_SZ /d %UNIX_TIME% /f /reg:64

call :OutputLogWithTime ASCI driver installation Finished!

:: call :OutputLogWithTime Try to get current ASCI driver version...
:: timeout /t 10 /nobreak
:: call :OutputASUSDeviceInformation
:: call :OutputLogWithTime Dump device information finisned!

echo.
goto :EOF

:: ==========================================================
::  Helper method
:: ==========================================================

:ScConfigService
setlocal enableextensions
echo ----------------------------------------------------------
sc config "%1" start=%2
echo Stop config %1 ExitCode=%errorlevel%
echo ----------------------------------------------------------
endlocal & goto :EOF

:ScStopService
setlocal enableextensions
echo ----------------------------------------------------------
sc stop %1
echo Stop service %1 ExitCode=%errorlevel%
echo ----------------------------------------------------------
endlocal & goto :EOF

:ScStartService
setlocal enableextensions
echo ----------------------------------------------------------
sc start %1
echo Start service %1 ExitCode=%errorlevel%
echo ----------------------------------------------------------
endlocal & goto :EOF

:GetUnixTime
setlocal enableextensions
for /f %%x in ('wmic path win32_utctime get /format:list ^| findstr "="') do (
    set %%x)
set /a z=(14-100%Month%%%100)/12, y=10000%Year%%%10000-z
set /a ut=y*365+y/4-y/100+y/400+(153*(100%Month%%%100+12*z-3)+2)/5+Day-719469
set /a ut=ut*86400+100%Hour%%%100*3600+100%Minute%%%100*60+100%Second%%%100
endlocal & set "%1=%ut%" & goto :EOF

:OutputLogWithTime
setlocal enableextensions
for /F "tokens=2" %%i in ('date /t') do set mydate=%%i
set mytime=%time%
echo [%mydate%:%mytime%] %*
endlocal & goto :EOF

:OutputAsusDeviceInformation
setlocal enableextensions
echo Current Device Information:
powershell.exe -command "Get-WmiObject Win32_PnPSignedDriver | where-object {$_.DeviceID -like '*ASUS*'} | Select DeviceName, DeviceId, DriverVersion, DriverDate"
endlocal & goto :EOF
